% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{MKFstep.fading}
\alias{MKFstep.fading}
\title{One Propagation Step under Mixture Kalman Filter for Fading Channels}
\usage{
MKFstep.fading(mm, II, mu, SS, logww, yyy, par, xdim, ydim, resample)
}
\arguments{
\item{mm}{the Monte Carlo sample size.}

\item{II}{the indicators.}

\item{mu}{the mean in the last iteration.}

\item{SS}{the covariance matrix of the Kalman filter components in the last iteration.}

\item{logww}{is the log weight of the last iteration.}

\item{yyy}{the observations with \code{T} columns and \code{ydim} rows.}

\item{par}{a list of parameter values. \code{HH} is the state coefficient matrix, \code{WW*t(WW)} is the state innovation covariance matrix,
\code{VV*t(VV)} is the covariance matrix of the observation noise, \code{GG1} and \code{GG2} are the observation coefficient matrix.}

\item{xdim}{the dimension of the state varible \code{x_t}.}

\item{ydim}{the dimension of the observation \code{y_t}.}

\item{resample}{a binary vector of length \code{obs}, reflecting the resampling schedule. resample.sch[i]= 1 indicating resample should be carried out at step \code{i}.}
}
\value{
The function returns a list with components:
\item{xhat}{the fitted value.}
\item{xhatRB}{the fitted value using Rao-Blackwellization.}
\item{Iphat}{the estimated indicators.}
\item{IphatRB}{the esitmated indicators using Rao-Blackwellization.}
}
\description{
This function implements the one propagation step under mixture Kalman filter for fading channels.
}
\references{
Tsay, R. and Chen, R. (2019). Nonlinear Time Series Analysis. Wiley, New Jersey.
}
