% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{mTAR}
\alias{mTAR}
\title{Estimation of a Multivariate Two-Regime SETAR Model}
\usage{
mTAR(y, p1, p2, thr = NULL, thrV = NULL, delay = c(1, 1),
  Trim = c(0.15, 0.85), k0 = 300, include.mean = TRUE,
  score = "AIC")
}
\arguments{
\item{y}{a (\code{nT}-by-\code{k}) data matrix of multivariate time series, where \code{nT} is the sample size and \code{k} is the dimension.}

\item{p1}{AR-order of regime 1.}

\item{p2}{AR-order of regime 2.}

\item{thr}{threshold variable. Estimation is needed if \code{thr} = NULL.}

\item{thrV}{vector of threshold variable. If it is not null, thrV must have the same sample size of that of y.}

\item{delay}{two elements (i,d) with "i" being the component and "d" the delay for threshold variable.}

\item{Trim}{lower and upper quantiles for possible threshold value.}

\item{k0}{the maximum number of threshold values to be evaluated.}

\item{include.mean}{logical values indicating whether constant terms are included.}

\item{score}{the choice of criterion used in selection threshold, namely (AIC, det(RSS)).}
}
\value{
mTAR returns a listh with the following components:
\item{data}{the data matrix, y.}
\item{beta}{a (\code{p*k+1})-by-(\code{2k}) matrices. The first \code{k} columns show the estimation results in regime 1, and the second \code{k} columns show these in regime 2.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{residuals}{estimated innovations.}
\item{nobs}{numbers of observations in regimes 1 and 2.}
\item{model1, model2}{estimated models of regimes 1 and 2.}
\item{thr}{threshold value.}
\item{delay}{two elements (\code{i},\code{d}) with "\code{i}" being the component and "\code{d}" the delay for threshold variable.}
\item{thrV}{vector of threshold variable.}
\item{D}{a set of positive threshold values.}
\item{RSS}{residual sum of squares.}
\item{information}{overall information criteria.}
\item{cnst}{logical values indicating whether the constant terms are included in regimes 1 and 2.}
\item{sresi}{standardized residuals.}
}
\description{
Estimation of a multivariate two-regime SETAR model, including threshold.
The procedure of Li and Tong (2016) is used to search for the threshold.
}
\examples{
phi1=matrix(c(0.5,0.7,0.3,0.2),2,2)
phi2=matrix(c(0.4,0.6,0.5,-0.5),2,2)
sigma1=matrix(c(1,0,0,1),2,2)
sigma2=matrix(c(1,0,0,1),2,2)
c1=c(0,0)
c2=c(0,0)
delay=c(1,1)
Trim=c(0.2,0.8)
include.mean=TRUE
y=mTAR.sim(1000,0,phi1,phi2,sigma1,sigma2,c1,c2,delay,ini=500)
est=mTAR(y$series,1,1,0,y$series,delay,Trim,300,include.mean,"AIC")
est2=mTAR(y$series,1,1,NULL,y$series,delay,Trim,300,include.mean,"AIC")
}
\references{
Li, D., and Tong. H. (2016) Nested sub-sample search algorithm for estimation of threshold models. \emph{Statisitca Sinica}, 1543-1554.
}
