% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{simu_fading}
\alias{simu_fading}
\title{Simulate Signals from A System with Rayleigh Flat-Fading Channels}
\usage{
simu_fading(nobs, par)
}
\arguments{
\item{nobs}{sample size.}

\item{par}{a list with following components: \code{HH} is the state coefficient matrix; \code{WW}, \code{WW*t(WW)} is the state innovation covariance matrix;
\code{VV}, \code{VV*t(VV)} is the observation noise covariance matrix; \code{GG} is the observation model.}
}
\description{
The function generates a sample from a system with Rayleigh flat-fading channels.
}
\examples{
HH <- matrix(c(2.37409, -1.92936, 0.53028,0,1,0,0,0,0,1,0,0,0,0,1,0),ncol=4,byrow=TRUE)
WW <- matrix(c(1,0,0,0),nrow=4)
GG <- matrix(0.01*c(0.89409,2.68227,2.68227,0.89409),nrow=1)
VV <- 1.3**15*0.0001
par <- list(HH=HH,WW=WW,GG=GG,VV=VV)
set.seed(1)
simu <- simu_fading(200,par)
}
