% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual_information_elements.R
\name{mutual.information}
\alias{mutual.information}
\title{Calculates the pointwise mutual information of units with each other}
\usage{
mutual.information(netfacs.data)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}
}
\value{
Function returns a dataframe that includes all combinations, their
  occurrence counts and probabilities, and the pointwise mutual information
  (standardised between -1 and 1). 1 means seeing one necessitates seeing the
  other, -1 means one precludes the other
}
\description{
Calculates the pointwise mutual information of units with each other
}
\examples{
### how do angry facial expressions differ from non-angry ones?
\donttest{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = NULL,
  test.condition = NULL,
  ran.trials = 100,
  combination.size = 4
)

mutual.information(angry.face)
}
}
