% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{MIN.int}
\alias{MIN.int}
\title{Minimum (MIN) network integration}
\usage{
MIN.int(drastic = FALSE, ...)
}
\arguments{
\item{drastic}{if TRUE the minimum is zero if at least one edge is not present
in a network (def: FALSE).}

\item{...}{a list of numeric matrices. These must be named matrices representing
adjacency matrices of the networks. Matrices may have different dimensions,
but corresponding elements in different matrices must have the same name.}
}
\value{
the integrated matrix : the matrix resulting from MIN.
}
\description{
It performs the Min integration between networks:
\loadmathjax
\mjsdeqn{\bar{w}_{ij} = \min_{d} w_{ij}^d}
Note that this function consider the minimum between existing edges, that is
if an edge (i,j) is not present in a network, since one of the nodes
i or j is not present in the network, then the edge is not considered in the
computation. If the edge (i,j) is not present in any of the available
networks, that its value is 0. If drastic=TRUE the minimum is zero if at least
one edge is not present in a network.
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Integrate networks using Minimum (MIN) method
A_int.noDrastic <- MIN.int(drastic = FALSE, A1, A2, A3);

# Integrate networks using Minimum (MIN) method (drastic integration)
A_int.drastic <- MIN.int(drastic = TRUE, A1, A2, A3);
}
