% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{setXY}
\alias{setXY}
\alias{setXY,agentMatrix,numeric,numeric,missing,ANY-method}
\alias{setXY,agentMatrix,numeric,numeric,worldNLR,logical-method}
\title{Set turtles' locations}
\usage{
setXY(turtles, xcor, ycor, world, torus = FALSE)

\S4method{setXY}{agentMatrix,numeric,numeric,missing,ANY}(turtles, xcor,
  ycor, torus)

\S4method{setXY}{agentMatrix,numeric,numeric,worldNLR,logical}(turtles,
  xcor, ycor, world, torus = FALSE)
}
\arguments{
\item{turtles}{AgentMatrix object representing the moving agents.}

\item{xcor}{Numeric. Vector of x coordinates. Must be of length 1 or
of length \code{turtles}.}

\item{ycor}{Numeric. Vector of y coordinates. Must be of length 1 or
of length \code{turtles}.}

\item{world}{WorldMatrix or worldArray object.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
AgentMatrix representing the \code{turtles} with updated coordinates
        and updated data for their previous coordinates "prevX" and "prevY"
}
\description{
Set the turtles \code{xcor} and \code{ycor} coordinates.
}
\details{
\code{world} must be provided only if \code{torus = TRUE}.

         If the given coordinates \code{[xcor, ycor]}
         are located outside of the \code{world}'s extent and \code{torus = TRUE},
         then the coordinates assigned to the turtle
         are the ones from a wrapped \code{word}; if \code{torus = FALSE}, the turtle
         is located outside of the \code{world}'s extent with the given coordinates.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9,
                          data = runif(100))
t1 <- createTurtles(n = 5, coords = randomXYcor(w1, n = 5))
plot(w1)
points(t1, col = of(agents = t1, var = "color"), pch = 16)

t1 <- setXY(turtles = t1, xcor = 1:5, ycor = 1:5)
points(t1, col = of(agents = t1, var = "color"), pch = 16)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#setxy}
}
\author{
Sarah Bauduin
}
