% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head.mmsbm.R
\name{head.mmsbm}
\alias{head.mmsbm}
\title{Identify nodes with most frequent membership in latent groups}
\usage{
\method{head}{mmsbm}(x, n = 6, t = NULL, node = TRUE,
  t.correct = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{mmsbm}, a result of a call to \code{mmsbm}.}

\item{n}{Numeric or integer; specifies how many units will be identified for each group.}

\item{t}{Optional vector of time periods to be used for assessing latent group membership.}

\item{node}{Logical; indicates whether latent group memberships should be averaged at the node level.  If FALSE, the function returns the node-time period units with highest estimated membership in each latent group.}

\item{t.correct}{Logical; indicates whether latent group memberships should be corrected for temporal trends.  If TRUE, the function returns the node-time period units with highest estimated membership in each latent group.}

\item{...}{Currently ignored}
}
\value{
List of length \code{n.groups}.  Each entry contains a sorted vector of average latent membership probabilities of length \code{n}.
}
\description{
The function lists the nodes (optionally, node-time periods) that most frequently instantiate membership in each latent group.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
set.seed(123)
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2)

## Show top 6 lawyers in each estimated latent block
head(lazega_mmsbm)

}
\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
