#' NetSimR: A non-life insurance package for computating various statistics.
#'
#' The NetSimR package provides three categories of functions:
#' \enumerate{
#' \item Capped means, Exposure and ILF curve from various severity distributions
#' \item Pure IBNR and UPR earned periods
#' \item Sliced distributions
#' }
#'
#' @section NetSimR mean functions:
#' \code{\link{SlicedGammaParetoMean}}
#' \code{\link{SlicedLNormParetoMean}}
#'
#' @section NetSimR capped mean functions:
#' \code{\link{GammaCappedMean}}
#' \code{\link{LNormCappedMean}}
#' \code{\link{ParetoCappedMean}}
#' \code{\link{SlicedGammaParetoCappedMean}}
#' \code{\link{SlicedLNormParetoCappedMean}}
#'
#' @section NetSimR exposure curve functions:
#' \code{\link{ExposureCurveGamma}}
#' \code{\link{ExposureCurveLNorm}}
#' \code{\link{ExposureCurvePareto}}
#' \code{\link{ExposureCurveSlicedGammaPareto}}
#' \code{\link{ExposureCurveSlicedLNormPareto}}
#'
#' @section NetSimR ILF curve functions:
#' \code{\link{ILFGamma}}
#' \code{\link{ILFLNorm}}
#' \code{\link{ILFPareto}}
#' \code{\link{ILFSlicedGammaPareto}}
#' \code{\link{ILFSlicedLNormPareto}}
#'
#' @section NetSimR pure IBNR functions:
#' \code{\link{PureIBNRGamma}}
#' \code{\link{PureIBNRLNorm}}
#'
#' @section NetSimR Sliced distribution functions:
#' \code{\link{dSlicedGammaPareto}}
#' \code{\link{dSlicedLNormPareto}}
#' \code{\link{pSlicedGammaPareto}}
#' \code{\link{pSlicedLNormPareto}}
#' \code{\link{qSlicedGammaPareto}}
#' \code{\link{qSlicedLNormPareto}}
#'
#' @docType package
#' @name NetSimR
NULL
