% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeansU.R
\name{kmeansU}
\alias{kmeansU}
\title{K-mean clustering of latent node positions}
\usage{
kmeansU(out, R = 2, n.cluster = 3, layer = 1, main = "")
}
\arguments{
\item{out}{Output of networkchange objects.}

\item{R}{Number of latent space dimensions}

\item{n.cluster}{Number of latent cluster}

\item{layer}{Layer id for the cluster analysis}

\item{main}{Title}
}
\value{
A plot object
}
\description{
K-mean clustering of latent node positions
}
\examples{

   \dontrun{set.seed(1973)
   ## generate an array with two constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=10, T=10, type ="constant")
   out0 <- NetworkStatic(Y, R=2, mcmc=10, burnin=10,
   verbose=10, UL.Normal = "Orthonormal")
   ## latent node positions
   kmeansU(out0)
   }
}
