% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netinf.R
\name{netinf}
\alias{netinf}
\title{Infer latent diffusion network}
\usage{
netinf(cascades, trans_mod = "exponential", n_edges = NULL,
  p_value_cutoff = NULL, params = NULL, quiet = FALSE, trees = FALSE)
}
\arguments{
\item{cascades}{an object of class cascade containing node and cascade 
information. See \code{\link{as_cascade_long}} and 
\code{\link{as_cascade_wide}} for details.}

\item{trans_mod}{character, indicating the choice of model: 
\code{"exponential"}, \code{"rayleigh"} or \code{"log-normal"}.}

\item{n_edges}{integer, number of edges to infer. Leave unspecified if using 
\code{p_value_cutoff}.}

\item{p_value_cutoff}{numeric, in the interval (0, 1). If 
specified, edges are inferred in each iteration until the Vuong test for 
edge addition reaches the p-value cutoff or when the maximum 
possible number of edges is reached. Leave unspecified if using 
\code{n_edges} to explicitly specify number of edges to infer.}

\item{params}{numeric, Parameters for diffusion model. If left unspecified 
reasonable parameters are inferred from the data. See details for how to 
specify parameters for the different distributions.}

\item{quiet}{logical, Should output on progress by suppressed.}

\item{trees}{logical, Should the inferred cascade trees be returned. Note, 
that this will lead to a different the structure of the function output. 
See section Value for details.}
}
\value{
Returns the inferred diffusion network as an edgelist in an object of 
    class \code{diffnet} and \code{\link[base]{data.frame}}. The first 
    column contains the sender, the second column the receiver node. The 
    third column contains the improvement in fit from adding the edge that is
    represented by the row. The output additionally has the following 
    attributes:
    \itemize{
        \item \code{"diffusion_model"}: The diffusion model used to infer the 
            diffusion network.
        \item \code{"diffusion_model_parameters"}: The parameters for the 
            model that have been inferred by the approximate profile MLE 
            procedure.
    }
    If the argument \code{trees} is set to \code{TRUE}, the output is a list
    with the first element being the \code{data.frame} described above, and 
    the second element being the trees in edge-list form in a single 
    \code{data.frame}.
}
\description{
Infer a network of diffusion ties from a set of cascades. Each cascade 
is defined by pairs of node ids and infection times.
}
\details{
The algorithm is describe in detail in Gomez-Rodriguez et al. (2010). 
Additional information can be found on the 
netinf website (\url{http://snap.stanford.edu/netinf/}).

\itemize{
    \item Exponential distribution: \code{trans_mod = "exponential"},
    \code{params = c(lambda)}. 
    Parametrization: \eqn{\lambda e^{-\lambda x}}.
    \item Rayleigh distribution: \code{trans_mod = "rayleigh"},
    \code{params = c(alpha)}. 
    Parametrization: \eqn{\frac{x}{\alpha^2} \frac{e^{-x^2}}{2\alpha^2}}.
    \item Log-normal distribution: \code{trans_mod = "log-normal"},
    \code{params = c(mu, sigma)}. 
    Parametrization: \eqn{\frac{1}{x\sigma\sqrt{2\pi}}e^{-\frac{(ln x - \mu)^2}{2\sigma^2}}}.
}

If higher performance is required and for very large data sets, a faster pure C++ 
implementation is available in the Stanford Network Analysis Project (SNAP). 
The software can be downloaded at \url{http://snap.stanford.edu/netinf/}.
}
\examples{

# Data already in cascades format:
data(cascades)
out <- netinf(cascades, trans_mod = "exponential", n_edges = 5, params = 1)

# Starting with a dataframe
df <- simulate_rnd_cascades(10, n_nodes = 20)
cascades2 <- as_cascade_long(df, node_names = unique(df$node_name))
out <- netinf(cascades2, trans_mod = "exponential", n_edges = 5, params = 1)

}
\references{
M. Gomez-Rodriguez, J. Leskovec, A. Krause. Inferring Networks of Diffusion 
and Influence.The 16th ACM SIGKDD Conference on Knowledge Discovery and 
Data Mining (KDD), 2010.
}
