% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{TMFG}
\alias{TMFG}
\title{Triangulated Maximally Filtered Graph}
\usage{
TMFG(data, binary = FALSE, weighted = TRUE)
}
\arguments{
\item{data}{Can be a dataset or a correlation matrix}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{weighted}{Should network be weighted? Defaults to TRUE. Set FALSE to produce an unweighted (binary) network}
}
\value{
A sparse association matrix
}
\description{
Applies the Triangulated Maximally Filtered Graph (TMFG) filtering method
}
\examples{
weighted_TMFGnetwork<-TMFG(data)

weighted_binary_TMFGnetwork<-TMFG(data,binary=TRUE)

unweighted_TMFGnetwork<-TMFG(data,weighted=FALSE)

unweighted_binary_TMFGnetwork<-TMFG(data,binary=TRUE,weighted=FALSE)
}
\references{
Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Network filtering for big data: Triangulated maximally filtered graph.
Journal of Complex Networks, 5(2), 161-178.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
