% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{commboot}
\alias{commboot}
\title{Bootstrapped Communities Likelihood}
\usage{
commboot(data, binary = FALSE, n = nrow(data), iter = 100,
  method = "louvain", steps = 4)
}
\arguments{
\item{data}{A set of data}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{n}{Number of people to use in the bootstrap. Defaults to full sample size}

\item{iter}{Number of bootstrap iterations. Defaults to 100 iterations}

\item{method}{Defaults to "louvain". Set to "walktrap" for the walktrap algorithm}

\item{steps}{Number of steps to use in the walktrap algorithm. Defaults to 4. Use a larger number of steps for smaller networks}
}
\value{
The factors and their proportion found across bootstrapped samples (i.e., their likelihood)
}
\description{
Bootstraps the sample with replace to compute walktrap reliability (TMFG-filtered networks only)
}
\examples{
commTMFG<-commboot(hex)
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.

Csardi, G., & Nepusz, T. (2006).
The igraph software package for complex network research.
\emph{InterJournal, Complex Systems}, \emph{1695}(5), 1-9.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
