% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{hybrid}
\alias{hybrid}
\title{Hybrid Centrality}
\usage{
hybrid(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of hybrid centrality values for each node in the network (higher values are more central, lower values are more peripheral)
}
\description{
Computes hybrid centrality of each node in a network
}
\examples{
A<-TMFG(hex)$A

HC<-hybrid(A)
}
\references{
Pozzi, F., Di Matteo, T., & Aste, T. (2013).
Spread of risk across financial markets: Better to invest in the peripheries. 
\emph{Scientific Reports}, \emph{3}(1655), 1-7.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
