% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{prepboot}
\alias{prepboot}
\title{Bootstrapped Network Preprocessing}
\usage{
prepboot(data, method, binary = FALSE, n = nrow(data), iter = 1000,
  a = 0.05, depend = FALSE)
}
\arguments{
\item{data}{A set of data}

\item{method}{A network filtering method (e.g, "TMFG", "MaST", "ECO", "ECOplusMaST")}

\item{binary}{Is dataset dichotomous? Defaults to FALSE. Set TRUE if dataset is dichotomous (tetrachoric correlations are computed)}

\item{n}{Number of people to use in the bootstrap. Defaults to full sample size}

\item{iter}{Number of bootstrap iterations. Defaults to 1000 iterations}

\item{a}{Alpha to be used for determining the critical value of correlation coefficients. Defaults to .05}

\item{depend}{Is network a dependency (or directed) network? Defaults to FALSE. Set TRUE to generate a TMFG-filtered dependency network}
}
\value{
Returns a list that includes the original filtered network (orignet),
correlation matrix of the mean bootstrapped network (bootmat),
reliabilities of the connections in the original network (netrel),
reliabilities of the connections in the bootstrapped network (bootrel),
a plot of the bootrel reliability matrix (netrel; upper triangle = actual network reliabilites, bootrel; lower triangle = overall network reliablities),
a plot of included correlations on their reliability (ConR)
}
\description{
Bootstraps the sample to identify the most stable correlations
}
\examples{
\dontrun{

prepTMFG<-prepboot(hex,method="TMFG")
}
}
\references{
Tumminello, M., Coronnello, C., Lillo, F., Micciche, S., & Mantegna, R. N. (2007).
Spanning trees and bootstrap reliability estimation in correlation-based networks.
\emph{International Journal of Bifurcation and Chaos}, \emph{17}(7), 2319-2329.

Wei, T. & Simko, V.(2017).
R package "corrplot": Visualization of a correlation matrix (Version 0.84).
Available from \url{https://github.com/taiyun/corrplot}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
