% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{betweenness}
\alias{betweenness}
\title{Betwenness Centrality}
\usage{
betweenness(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to TRUE.
Set to FALSE for unweighted measure of betwenness centrality}
}
\value{
A vector of betweenness centrality values for each node in the network
}
\description{
Computes betweenness centrlaity of each node in a network
}
\examples{
A<-TMFG(hex)$A

weighted_BC<-betweenness(A)

unweighted_BC<-betweenness(A,weighted=FALSE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
