% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{leverage}
\alias{leverage}
\title{Leverage Centrality}
\usage{
leverage(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to TRUE.
Set to FALSE for unweighted measure of leverage centrality}
}
\value{
A vector of leverage centrality values for each node in the network
}
\description{
Computes leverage centrlaity of each node in a network (the degree of connected neighbors)
(Please see and cite Joyce et al., 2010)
}
\examples{
A<-TMFG(hex)$A

weighted_lev<-leverage(A)

unweighted_lev<-leverage(A, weighted=FALSE)
}
\references{
Joyce, K. E., Laurienti, P. J., Burdette, J. H., & Hayasaka, S. (2010).
A new measure of centrality for brain networks. 
\emph{PLoS One}, \emph{5}(8), e12200.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
