% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{strength}
\alias{strength}
\title{Node Strength}
\usage{
strength(A)
}
\arguments{
\item{A}{An adjacency matrix of network data}
}
\value{
A vector of strength values for each node in the network.
If directed network, returns a list of in-strength (inStrength), out-strength (outStrength), and relative influence (relInf)
}
\description{
Computes strength of each node in a network
}
\examples{
A<-TMFG(neoOpen)$A

str<-strength(A)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
