% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFCF.R
\name{MFCF}
\alias{MFCF}
\title{Maximally Filtered Clique Forest}
\usage{
MFCF(data, cases = NULL, na.data = c("pairwise", "listwise", "fiml",
  "none"), time.series = FALSE, gain.fxn = c("logLik", "logLik.val",
  "rSquared.val"), min_size = 0, max_size = 8, pval = 0.05,
  pen = 0, drop_sep = FALSE, use_returns = FALSE)
}
\arguments{
\item{data}{Matrix (n \code{x} n or p \code{x} n) or data frame.
Can be a dataset or a correlation matrix}

\item{cases}{Numeric. If \code{data} is a (partial) correlation
matrix, then number of cases must be input.
Defaults to \code{NULL}}

\item{na.data}{Character.
How should missing data be handled?

\itemize{

\item{\code{"listwise"}}
{Removes case if \strong{any} missing data exists.
Applies \code{\link{na.omit}}}

\item{\code{"pairwise"}}
{Estimates correlations using the available data
for each variable}

\item{\code{"fiml"}}
{Estimates correlations using the Full Information
Maximum Likelihood. Recommended and most robust but time consuming}

\item{\code{"none"}}
{Default. No missing data or missing data has been
handled by the user}

}}

\item{time.series}{Boolean.
Is \code{data} a time-series dataset?
Defaults to \code{FALSE}.
Set to \code{TRUE} to handle time-series data (n \code{x} p)}

\item{gain.fxn}{Character.
Gain function to be used for inclusion of nodes in cliques.
There are several options available
(see \code{\link[NetworkToolbox]{gain.functions}} for more details):
\code{"logLik"}, \code{"logLik.val"}, \code{"rSquared.val"}.
Defaults to \code{"rSquared.val"}}

\item{min_size}{Numeric. Minimum number of nodes allowed per
clique. Defaults to \code{0}}

\item{max_size}{Numeric. Maximum number of nodes allowed per
clique. Defaults to \code{8}}

\item{pval}{Numeric. \emph{p}-value used to determine cut-offs for nodes
to include in a clique}

\item{pen}{Numeric. Multiplies the number of edges added to penalise 
complex models. Similar to the penalty term in AIC}

\item{drop_sep}{Boolean. This parameter influences the MFCF only.
Defaults to \code{FALSE}.
If \code{TRUE}, then any separator can be used only once (similar
to the \code{\link[NetworkToolbox]{TMFG}})}

\item{use_returns}{Boolean. Only used in \code{"gain.fxn = rSquared.val"}.
If set to \code{TRUE} the regression is 
performed on log-returns.
Defaults to \code{FALSE}}
}
\value{
Returns a list containing:

\item{A}{MFCF filtered partial correlation network (adjacency matrix)}

\item{J}{MFCF filtered inverse covariance matrix (precision matrix)}

\item{cliques}{Cliques in the network
(output for \code{\link[NetworkToolbox]{LoGo}})}

\item{separators}{Separators in the network
(output for \code{\link[NetworkToolbox]{LoGo}})}
}
\description{
Applies the Maximally Filtered Clique Forest (MFCF) filtering method
(\strong{Please see and cite Massara & Aste}).
}
\examples{
# Load data
data <- neoOpen

\dontrun{ 
# Use polychoric correlations and R-squared method
MFCF.net <- MFCF(qgraph::cor_auto(data), cases = nrow(neoOpen))$A

}

}
\references{
Massara, G. P. & Aste, T. (2019).
Learning clique forests.
\href{https://arxiv.org/abs/1905.02266}{https://arxiv.org/abs/1905.02266}
}
\author{
Guido Previde Massara <gprevide@gmail.com> and Alexander Christensen <alexpaulchristensen@gmail.com>
}
