% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.chordal.R
\name{sim.chordal}
\alias{sim.chordal}
\title{Simulate Chordal Network}
\usage{
sim.chordal(
  nodes,
  inverse = c("cases", "matrix"),
  n = NULL,
  ordinal = FALSE,
  ordLevels = NULL,
  idio = NULL,
  eps = NULL
)
}
\arguments{
\item{nodes}{Numeric.
Number of nodes in the simulated network}

\item{inverse}{Character.
Method to produce inverse covariance matrix.

\itemize{

\item{\code{"cases"}}{Estimates inverse covariance matrix
based on \code{n} number of cases and \code{nodes} number of
variables, which are drawn from a random normal distribution
\code{\link{rnorm}}. Data generated will be continuous unless
\code{ordinal} is set to \code{TRUE}}

\item{\code{"matrix"}Estimates inverse covariance matrix
based on ??eps??}

}}

\item{n}{Numeric.
Number of cases in the simulated dataset}

\item{ordinal}{Boolean.
Should simulated continuous data be converted to ordinal?
Defaults to \code{FALSE}.
Set to \code{TRUE} for simulated ordinal data}

\item{ordLevels}{Numeric.
If \code{ordinal = TRUE}, then how many levels should be used?
Defaults to \code{5}.
Set to desired number of intervals}

\item{idio}{Numeric.
DESCRIPTION.
Defaults to \code{0.10}}

\item{eps}{Numeric.
DESCRIPTION.
Defaults to \code{2}}
}
\value{
Returns a list containing: 

\item{cliques}{The cliques in the network}

\item{separators}{The separators in the network}

\item{inverse}{Simulated inverse covariance matrix of the network}

\item{data}{Simulated data from sim.correlation in the \code{\link{psych}}
package based on the simulated network}
}
\description{
Simulates a chordal network based on number of nodes.
Data will also be simulated based on the true network structure
}
\examples{
#Continuous data
sim.Norm <- sim.chordal(nodes = 20, inverse = "cases", n = 1000)

#Ordinal data
sim.Likert <- sim.chordal(nodes = 20, inverse = "cases", n = 1000, ordinal = TRUE)

#Dichotomous data
sim.Binary <- sim.chordal(nodes = 20, inverse = "cases", n = 1000, ordinal = TRUE, ordLevels = 5)

}
\references{
Massara, G. P. & Aste, T. (2019).
Learning clique forests.
\emph{ArXiv}.
}
\author{
Guido Previde Massara <gprevide@gmail.com>
}
