% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modues.R
\name{nlin_causality.test}
\alias{nlin_causality.test}
\title{A non linear Granger causality test}
\usage{
nlin_causality.test(ts1, ts2, lag, LayersUniv, LayersBiv, iters, bias = TRUE)
}
\arguments{
\item{ts1}{Numerical series.}

\item{ts2}{Numerical series.}

\item{lag}{The lag parameter}

\item{LayersUniv}{Integer vector that contains the size of hidden layers of the univariate model. The length of this vector is the number of hidden layers, and the i-th element is the number of neurons in the i-th hidden layer.}

\item{LayersBiv}{Integer vector that contains the size of hidden layers of the bivariate model. The length of this vector is the number of hidden layers, and the i-th element is the number of neurons in the i-th hidden layer.}

\item{iters}{The number of iterations.}

\item{bias}{Logical argument  for the option of using the bias in the networks.}
}
\value{
gci: the Granger causality index.

Ftest:  the statistic of the test.

pvalue: the p-value of the test.

summary ():  shows the test results.
}
\description{
A non linear Granger causality test
}
\details{
The test evaluates if the second time series causes the first one. Two MLP artificial neural networks are evaluated to perform the test, one using just the target time series (ts1), and the second using both time series.
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
data = LPP2005REC
# We construct the model based
model = nlin_causality.test (data[,1], data[,2], 2, c(2, 2), c(4, 4), 500, TRUE)
model$summary ()
}
