% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-pair-links-are-symmetric.R
\name{ValidatePairLinksAreSymmetric}
\alias{ValidatePairLinksAreSymmetric}
\title{Verifies that the pair relationships are symmetric.}
\usage{
ValidatePairLinksAreSymmetric(linksPair)
}
\arguments{
\item{linksPair}{A \link[base:data.frame]{base::data.frame} containing the pair relationships that should be symmetric}
}
\value{
Returns \code{TRUE} if symmetric.  Throw an error with \code{\link[base:stop]{base::stop()}} if asymmetric.
}
\description{
Validates that the \code{linksPair} data frame is symmetric.
In a symmetric \code{linksPair}, each row has a corresponding row with reversed SubjectTag_S1 and SubjectTag_S2,
but the same \code{R} value.
For certain analyses (like types of DF methods and some
spatially-inspired methods), the pairs links (which can be considered a type of
sparse matrix) need to be symmetric. For example, if Subject 201 is related to
Subject 202 with a value of \code{R=0.5}, then there must be
a reciprocal row where Subject 202 is related to Subject 201 with \code{R=0.5}.
}
\examples{
dsSingleLinks <- data.frame(
  ExtendedID       = c(1, 1, 1, 2),
  SubjectTag_S1    = c(101, 101, 102, 201),
  SubjectTag_S2    = c(102, 103, 103, 202),
  R                = c(.5, .25, .25, .5),
  RelationshipPath = rep("Gen2Siblings", 4)
)
dsSingleOutcomes <- data.frame(
  SubjectTag = c(101, 102, 103, 201, 202),
  DV1        = c(11, 12, 13, 41, 42),
  DV2        = c(21, 22, 23, 51, 52)
)
dsDouble <- CreatePairLinksDoubleEntered(
  outcomeDataset         = dsSingleOutcomes,
  linksPairDataset       = dsSingleLinks,
  outcomeNames           = c("DV1", "DV2"),
  validateOutcomeDataset = TRUE
)
dsDouble # Show the 8 rows in the double-entered pair links
summary(dsDouble) # Summarize the variables

ValidatePairLinksAreSymmetric(dsDouble) # Should return TRUE.

}
\seealso{
\code{\link[=CreatePairLinksDoubleEntered]{CreatePairLinksDoubleEntered()}}
}
\author{
Will Beasley
}
\keyword{validation}
