% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ENN.R
\name{ENN}
\alias{ENN}
\alias{ENN.default}
\alias{ENN.formula}
\title{Edited Nearest Neighbors}
\usage{
\method{ENN}{formula}(formula, data, ...)

\method{ENN}{default}(x, k = 3, classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{k}{Number of nearest neighbors to be used.}

\item{classColumn}{positive integer indicating the column which contains the
(factor of) classes. By default, the last column is considered.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} is a factor containing the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Similarity-based filter for removing label noise from a dataset as a
preprocessing step of classification. For more information, see 'Details' and
'References' sections.
}
\details{
\code{ENN} finds the \code{k} nearest neighbors for each instance, which is removed
if the majority class in this neighborhood is different from its class.
}
\examples{
data(iris)
out <- ENN(Species~., data = iris, k = 5)
summary(out)
identical(out$cleanData, iris[setdiff(1:nrow(iris),out$remIdx),])
}
\references{
Wilson D. L. (1972): Asymptotic properties of nearest neighbor rules using edited data.
\emph{Systems, Man and Cybernetics, IEEE Transactions on}, (3), 408-421.
}

