% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{PF}
\alias{PF}
\alias{PF.default}
\alias{PF.formula}
\title{Partitioning Filter}
\usage{
\method{PF}{formula}(formula, data, ...)

\method{PF}{default}(x, nfolds = 5, consensus = FALSE, p = 0.01, s = 3,
  y = 0.5, theta = 0.7, classColumn = ncol(x), ...)
}
\arguments{
\item{formula}{A formula describing the classification variable and the attributes to be used.}

\item{data, x}{Data frame containing the tranining dataset to be filtered.}

\item{...}{Optional parameters to be passed to other methods.}

\item{nfolds}{Number of partitions in each iteration.}

\item{consensus}{Logical. If FALSE, majority voting scheme is used. If TRUE, consensus
voting scheme is applied.}

\item{p}{Real number between 0 and 1. It sets the minimum proportion of original
instances which must be tagged as noisy in order to go for another iteration.}

\item{s}{Positive integer setting the stop criterion together with \code{p}. The filter stops
after \code{s} iterations with not enough noisy instances removed (according to the proportion \code{p}).}

\item{y}{Real number between 0 and 1. It sets the proportion of good instances which
must be stored in each iteration.}

\item{theta}{Real number between 0 and 1. It sets the proportion of 'good rules' to be selected (see also
'Details' section).}

\item{classColumn}{Positive integer indicating the column which contains the (factor of) classes.
By default, the last column is considered.}
}
\value{
An object of class \code{filter}, which is a list with seven components:
\itemize{
   \item \code{cleanData} is a data frame containing the filtered dataset.
   \item \code{remIdx} is a vector of integers indicating the indexes for
   removed instances (i.e. their row number with respect to the original data frame).
   \item \code{repIdx} is a vector of integers indicating the indexes for
   repaired/relabelled instances (i.e. their row number with respect to the original data frame).
   \item \code{repLab} is a factor containing the new labels for repaired instances.
   \item \code{parameters} is a list containing the argument values.
   \item \code{call} contains the original call to the filter.
   \item \code{extraInf} is a character that includes additional interesting
   information not covered by previous items.
}
}
\description{
Ensemble-based filter for removing label noise from a dataset as a
preprocessing step of classification. For more information, see 'Details' and
'References' sections.
}
\details{
The full description of the method can be looked up in the provided references.
A PART rules set (from RWeka) is built in each of the \code{nfolds} partitions of \code{data}. After a
'good rules selection' process based on the accuracy of each rule, the subsequent good rules sets are
tested in the whole dataset, and the removal of noisy instances is decided via consensus or
majority voting schemes. Finally, a proportion of good instances (i.e. those whose label agrees
with all the base classifiers) is stored and not considered in subsequent iterations. The process stops
after \code{s} iterations with not enough (according to the proportion \code{p}) noisy
instances removed.
}
\note{
The base rule classifier used is PART instead of C4.5rules used in the references.

For the 'good rules selection' step, we implement the 'Best-L rules' scheme since, according to
the authors, it usually outperforms the others 'Adaptive Threshold' and 'Fixed Threshold' schemes.

By means of a message, the number of noisy instances removed
in each iteration is displayed in the console.
}
\examples{
# Next example is not run in order to save time
\dontrun{
data(iris)
# We fix a seed since there exists a random partition for the ensemble
set.seed(1)
out <- PF(Species~., data = iris, s = 1, nfolds = 3)
print(out)
identical(out$cleanData, iris[setdiff(1:nrow(iris),out$remIdx),])
}
}
\references{
Zhu X., Wu X., Chen Q. (2003, August): Eliminating class noise in large
datasets. \emph{International Conference in Machine Learning} (Vol. 3, pp. 920-927).

Zhu X., Wu X., Chen Q. (2006): Bridging local and global data cleansing: Identifying class noise in
large, distributed data datasets. \emph{Data mining and Knowledge discovery}, 12(2-3), 275-308.
}

