\name{heatmap_NonParRolCor}
\alias{heatmap_NonParRolCor}
\alias{heatmap}
\title{Plot the variables under analysis and a heat map of the rolling correlation coefficients that are statistically significant
}
\description{The \code{\link{heatmap_NonParRolCor}} function plots the time series under study and create a heat map of the rolling window correlation coefficients that are statistically significant, which are generated by the \code{\link{estimation_NonParRolCor}} function. 
}
\usage{
heatmap_NonParRolCor(inputdata, corcoefs, CRITVAL, Rwidthwin="", typewidthwin="", 
                     widthwin_1=3, widthwin_N=dim(inputdata)[1], varX="X", 
                     varY="Y", coltsX="black", coltsY="blue", LWDtsX=1, LWDtsY=1, 
                     CEXLAB=1.15, CEXAXIS=1.05)
}
\arguments{
 \item{inputdata}{ 
The same data matrix (time, first and second variable) that was used with the \code{\link{estimation_NonParRolCor}} function. 
}
 \item{corcoefs}{
Rolling correlation coefficients estimated with the \code{\link{estimation_NonParRolCor}} function. 
}
 \item{CRITVAL}{ 
The critical values computed through the function \code{\link{estimation_NonParRolCor}}.
}
 \item{Rwidthwin}{ 
\emph{Rwidthwin} is a vector that contain the window lengths, which come from the function \code{\link{estimation_NonParRolCor}}.
}
 \item{typewidthwin}{ 
Contains the type (``FULL'' or ``PARTIAL'') of heat map that will be plotted, this information is provided by \code{\link{estimation_NonParRolCor}}. Please note that whether option \emph{typewidthwin}=``PARTIAL'' is selected, and you will need to provide the parameters \emph{widthwin_1} and \emph{widthwin_N} to plot the heat map. 
}
 \item{widthwin_1}{ 
First value for the size (length) of the windows when the option \emph{typewidthwin}=``PARTIAL'' is selected, this value is provided by the \code{\link{estimation_NonParRolCor}} function.
}
 \item{widthwin_N}{ 
Last value for the size (length) of the windows when the option \emph{typewidthwin}=``PARTIAL'' is selected, this value is provided by the \code{\link{estimation_NonParRolCor}} function.
}
 \item{varX, varY}{ 
Names of the first (e.g. \eqn{X}) and the second (e.g. \eqn{Y}) variables contained in \emph{inputdata}. Please note that the names of these two variables should be provided (by default are \eqn{X} and \eqn{Y}) when these variables are plotted. 
}
 \item{coltsX, coltsY}{ 
Colors to be used when the variables are plotted, by default are ``black'' for the first variable and ``blue'' for the second, but other colors can be used.
}
 \item{LWDtsX, LWDtsY}{
Line-widths for the first and the second variable when these are plotted, by default these have values of 1, but other values (widths) can be used.
}
 \item{CEXLAB, CEXAXIS}{
These parameters are used to plot the sizes of the X-axis and Y-axis labels and X- and Y-axis, by default these parameters have values of 1.15 and 1.05, respectively, but it is possible to use other values. 
}
}
\details{
The \code{\link{heatmap_NonParRolCor}} function plots the variables (time series) under analysis and a heat map of the rolling correlation coefficients that are statistically significant and that are estimated through a non-parametric computing-intensive method. The \code{\link{heatmap_NonParRolCor}} function uses the outputs of the \code{\link{estimation_NonParRolCor}} function. To implement this method we extend the works of Telford (2013), Polanco-Martínez (2019) and Polanco-Martínez (2020), and to implement the heat map we follow to Polanco-Martínez (2020). A detailed description of this method can be found in Polanco-Martínez and López-Martínez (2021). \code{\link{heatmap_NonParRolCor}} uses the functions \emph{diverge_hcl} (package:colorspace) and \emph{alpha} (package:scales) to create the palette of colors. 
}
\value{
Outputs:
A plot of the time series under analysis and a heat map (a multi-plot via screen) of the rolling window correlation coefficients statistically significant. This multi-plot can be saved in your preferred format. 
}
\author{
Josué M. Polanco-Martínez (a.k.a. jomopo).\cr
BC3 - Basque Centre for Climate Change, Bilbao, SPAIN.\cr 
Web1: \url{https://scholar.google.es/citations?user=8djLIhcAAAAJ&hl=en}.\cr
Web2: \url{https://www.researchgate.net/profile/Josue-Polanco-Martinez}.\cr
Email: \email{josue.m.polanco@gmail.com}.\cr
}
\references{
Polanco-Martínez, J. M. and López-Martínez, J.M. (2021). A non-parametric method to test the statistical significance in rolling window correlations, and applications to ecological time series. Submitted to Ecological Informatics (2021). \cr 

Polanco-Martínez, J. M. (2020). NonParRolCor: an R package for estimating rolling window multiple correlation in ecological time series. Ecological Informatics, 60, 101163. <URL: \doi{10.1016/j.ecoinf.2020.101163}>. \cr
}
\examples{
 # Code to test the function "heatmap_NonParRolCor"
 # Defining NonParRolCor parameters 
 # Example 4.1 "synthetic time series" (Figures 6 and 7) in 
 # Polanco-Martínez and López-Martínez (2021). 
 TYPEWIDTHWIN="PARTIAL"
 # Number of Monte-Carlo simulations (MCSim), please use at least 1000. 
 # WARNING: MCSim=2, it's just to test this example! 
 MCSim <- 2 
 Np    <- 2  # Number of cores 
 X_Y <- estimation_NonParRolCor(syntheticdata[1:350,], CorMethod="pearson", 
                   typewidthwin=TYPEWIDTHWIN, widthwin_1=29,
                   widthwin_N=51, Align="center", rmltrd=TRUE, 
                   Scale=TRUE, MCSim=MCSim, Np=Np)
 heatmap_NonParRolCor(syntheticdata[1:350,], X_Y$matcor, X_Y$CRITVAL, 
                   Rwidthwin=X_Y$Windows, typewidthwin=TYPEWIDTHWIN, 
                   widthwin_1=29, widthwin_N=51)
 }

\keyword{plot_time_series}
\keyword{plot_heatmap_Non-parametric_test_rolling_correlation}

