% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kruse_Unit_Root.R
\name{Kruse_Unit_Root}
\alias{Kruse_Unit_Root}
\title{Kruse(2011) nonlinear unit root test function}
\usage{
Kruse_Unit_Root(x, case, lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC, if 3 t-stat significance}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test Statistic" the value of the test statistic
}
\description{
This function allows you to make Kruse(2011) nonlinear unit root test
}
\examples{

x <- rnorm(1000)
Kruse_Unit_Root(x, case = 1, lags = 6, lsm =1)


y <- cumsum(rnorm(1000))
Kruse_Unit_Root(y, 3, 3, 3)


data(IBM)
Kruse_Unit_Root(IBM,case = 2,lags = 12,lsm = 2)


}
\references{
Kruse, R. (2011). A new unit root test against ESTAR based on a class of modified statistics. Statistical Papers, 52(1), 71-85.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
