% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormScaling.R
\name{NormScaling}
\alias{NormScaling}
\title{Normalisation methods based on scaling}
\usage{
NormScaling(featuredata, method = c("median", "mean", "sum", "ref"),
  refvec = NULL, saveoutput = FALSE, outputname = NULL, ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{method}{A character string indicating the required scaling-based normalization
method. Must be one of "\code{median}", "\code{mean}", "\code{sum}", or
"\code{ref}". See NormalizeMets Vignette for details.}

\item{refvec}{A reference vector to be used with the method "\code{ref}".}

\item{saveoutput}{A logical indicating whether the normalised data matrix
should be saved as a .csv file.}

\item{outputname}{The name of the output file if the output has to be saved.}

\item{...}{Arguments to other functions}
}
\value{
The result is an object of class
\code{\link[NormalizeMets:alldata]{alldata}}.
}
\description{
Normalise a metabolomic data matrix according to a specified scaling method.
}
\details{
The normalisation methods based on scaling include normalisation to a total
sum, or by the median or mean of each sample, and are denoted by
"\code{sum}", "\code{median}", and "\code{mean}" respectively. The method
"\code{ref}" normalises the metabolite abundances to a specified reference
vector.
}
\examples{

   ## Reading the data
     data(mixdata)
     featuredata <- mixdata$featuredata
     sampledata<-mixdata$sampledata
     metabolitedata<-mixdata$metabolitedata
     refvec<-featuredata[,which(metabolitedata$type =="IS")[1]]
    
    ## Normalise by the median
    norm_med <- NormScaling(featuredata, method = "median")
    
    ## Normalise by a reference vector, in this case an internal standard
    norm_is <- NormScaling(featuredata, method = "ref", 
        refvec=refvec)

    ## Normalise by the sum
    norm_sum <- NormScaling(featuredata, method = "sum")

   ## Rla Plots after normalising by the median
    RlaPlots(norm_med$featuredata, group= sampledata$batch)

}
\references{
De Livera, Alysha M De, M. Aho-Sysi, Laurent Jacob, 
J. Gagnon-Bartch, Sandra Castillo, J.A. Simpson, and Terence P. Speed. 
2015. Statistical Methods for Handling Unwanted Variation in 
Metabolomics Data. Analytical Chemistry 87 (7). American Chemical Society: 
3606-3615.
}
\seealso{
\code{\link[crmn]{normFit}}.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
