% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{defaults}
\alias{defaults}
\title{Default values passed to RotMat*}
\usage{
defaults(
  paramList,
  split = "entropy",
  dimX = NULL,
  weights = NULL,
  catLabel = NULL
)
}
\arguments{
\item{paramList}{A list (possibly empty), to be populated with a set of default values to be passed to a \code{RotMat*} function.}

\item{split}{The criterion used for splitting the variable. 'gini': gini impurity index (classification, default),
'entropy': information gain (classification) or 'mse': mean square error (regression).}

\item{dimX}{An integer denoting the number of columns in the design matrix X.}

\item{weights}{A vector of length same as \code{data} that are positive weights.(default NULL)}

\item{catLabel}{A category labels of class \code{list} in predictors. (default NULL, for details see Examples of \code{\link{ODT}})}
}
\value{
Default parameters of the RotMat* function.
\itemize{
\item \code{dimX} An integer denoting the number of columns in the design matrix X.
\item \code{dimProj} Number of variables to be projected, default \code{dimProj="Rand"}: random from 1 to ncol(X).
\item \code{numProj} the number of projection directions.(default \code{ceiling(sqrt(dimX))})
\item \code{catLabel} A category labels of class \code{list} in prediction variables, for details see Examples of \code{\link{ODRF}}.
\item \code{weights} A vector of length same as \code{data} that are positive weights.(default NULL)
\item \code{lambda} Parameter of the Poisson distribution (default 1).
\item \code{sparsity} A real number in \eqn{(0,1)} that specifies the distribution of non-zero elements in the random matrix.
When \code{sparsity}="pois" means that non-zero elements are generated by the p(\code{lambda}) Poisson distribution.
\item \code{prob} A probability \eqn{\in (0,1)} used for sampling from.
\item \code{randDist} Parameter of the Poisson distribution (default 1).
\item \code{split} The criterion used for splitting the variable. 'gini': gini impurity index (classification, default),
'entropy': information gain (classification) or 'mse': mean square error (regression).
\item \code{model} Model for projection pursuit. (see \code{\link{PPO}})
}
}
\description{
Given the parameter list and the categorical map this function populates the values of the parameter list accoding to our 'best'
known general use case parameters.
}
\examples{
set.seed(1)
paramList <- list(dimX = 8, numProj = 3, sparsity = 0.25, prob = 0.5)
(paramList <- defaults(paramList, split = "entropy"))
}
\seealso{
\code{\link{RotMatPPO}} \code{\link{RotMatRand}} \code{\link{RotMatRF}} \code{\link{RotMatMake}}
}
\keyword{rotation}
\keyword{tree}
