% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OHPL.R
\name{OHPL}
\alias{OHPL}
\title{Ordered Homogeneity Pursuit Lasso}
\usage{
OHPL(x, y, maxcomp, gamma, cv.folds = 5L, G = 30L, type = c("max",
  "median"), scale = TRUE, pls.method = "simpls")
}
\arguments{
\item{x}{Predictor matrix.}

\item{y}{Response matrix with one column.}

\item{maxcomp}{Maximum number of components for PLS.}

\item{gamma}{A number between (0, 1) for generating
the gamma sequence. An usual choice for gamma could be
\code{n * 0.05}, where \code{n} is a number in 2, 3, ..., 19.}

\item{cv.folds}{Number of cross-validation folds.}

\item{G}{Maximum number of variable groups.}

\item{type}{Find the maximum absolute correlation (\code{"max"})
or find the median of absolute correlation (\code{"median"}).
Default is \code{"max"}.}

\item{scale}{Should the predictor matrix be scaled?
Default is \code{TRUE}.}

\item{pls.method}{Method for fitting the PLS model.
Default is \code{"simpls"}. See section "Details"
in \code{\link[pls]{plsr}} for all possible options.}
}
\value{
A list of fitted OHPL model object with performance metrics.
}
\description{
This function fits the ordered homogeneity pursuit lasso (OHPL) model.
}
\examples{
# generate simulation data
dat = OHPL.sim(
  n = 100, p = 100, rho = 0.8,
  coef = rep(1, 10), snr = 3, p.train = 0.5,
  seed = 1010)

# split training and test set
x = dat$x.tr
y = dat$y.tr
x.test = dat$x.te
y.test = dat$y.te

# fit the OHPL model
fit = OHPL(x, y, maxcomp = 3, gamma = 0.5, G = 10, type = "max")
# selected variables
fit$Vsel
# make predictions
y.pred = predict(fit, x.test)
# compute evaluation metric RMSEP, Q2 and MAE for the test set
perf = OHPL.RMSEP(fit, x.test, y.test)
perf$RMSEP
perf$Q2
perf$MAE
}
\references{
You-Wu Lin, Nan Xiao, Li-Li Wang, Chuan-Quan Li, and Qing-Song Xu (2017).
Ordered homogeneity pursuit lasso for group variable selection with
applications to spectroscopic data.
\emph{Chemometrics and Intelligent Laboratory Systems} 168, 62-71.
\url{https://doi.org/10.1016/j.chemolab.2017.07.004}
}

