% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OHPL-datalist.R
\docType{data}
\name{beer}
\alias{beer}
\title{The beer dataset}
\usage{
data(beer)
}
\description{
The beer dataset contains 60 samples published by Norgaard et al.
Recorded with a 30mm quartz cell on the undiluted degassed beer
and measured from 1100 to 2250 nm (576 data points) in steps of 2 nm.
}
\examples{
data("beer")
x.cal <- beer$xtrain
dim(x.cal)
x.test <- beer$xtest
dim(x.test)
y.cal <- beer$ytrain
dim(y.cal)
y.test <- beer$ytest
dim(y.test)

X <- rbind(x.cal, x.test)
y <- rbind(y.cal, y.test)
n <- nrow(y)

set.seed(1001)
samp.idx <- sample(1L:n, round(n * 0.7))
X.cal <- X[samp.idx, ]
y.cal <- y[samp.idx]
X.test <- X[-samp.idx, ]
y.test <- y[-samp.idx]
}
\references{
Norgaard, L., Saudland, A., Wagner, J., Nielsen, J. P., Munck, L., &
Engelsen, S. B. (2000). Interval partial least-squares regression (iPLS):
a comparative chemometric study with an example from near-infrared
spectroscopy. \emph{Applied Spectroscopy}, 54(3), 413--419.
}
