% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPCR.R
\name{PPCR}
\alias{PPCR}
\title{Perturbation-based Principal Component Regression}
\usage{
PPCR(data, eta = 0.0035, m = 3, alpha = 0.05, perturbation_factor = 0.1)
}
\arguments{
\item{data}{A data frame containing the response variable and predictors.}

\item{eta}{A proportion (between 0 and 1) determining the initial sample size for PCA.}

\item{m}{The number of principal components to retain.}

\item{alpha}{Significance level (currently not used in the function).}

\item{perturbation_factor}{A factor controlling the magnitude of perturbation added to the principal components.}
}
\value{
A list containing the following components:
\item{Bhat}{Estimated regression coefficients in the original space.}
\item{RMSE}{Root Mean Squared Error of the regression model.}
\item{summary}{Summary of the linear regression model.}
\item{Vhat}{Estimated principal components.}
\item{lambdahat}{Estimated eigenvalues.}
\item{yhat}{Predicted values from the regression model.}
}
\description{
This function performs Perturbation-based Principal Component Regression (PPCR) on the provided dataset.
It combines Principal Component Analysis (PCA) with linear regression, incorporating perturbation to enhance robustness.
}
\details{
The function first standardizes the predictors, then performs PCA on an initial subset of the data.
It iteratively updates the principal components by incorporating new observations and adding random perturbations.
Finally, it fits a linear regression model using the principal components as predictors and transforms the coefficients back to the original space.
}
\examples{
set.seed(1234)
library(MASS)
n <- 2000
p <- 10
mu0 <- as.matrix(runif(p, 0))
sigma0 <- as.matrix(runif(p, 0, 10))
ro <- as.matrix(c(runif(round(p / 2), -1, -0.8), runif(p - round(p / 2), 0.8, 1)))
R0 <- ro \%*\% t(ro)
diag(R0) <- 1
Sigma0 <- sigma0 \%*\% t(sigma0) * R0
x <- mvrnorm(n, mu0, Sigma0)
colnames(x) <- paste("x", 1:p, sep = "")
e <- rnorm(n, 0, 1)
B <- sample(1:3, (p + 1), replace = TRUE)
en <- matrix(rep(1, n * 1), ncol = 1)
y <- cbind(en, x) \%*\% B + e
colnames(y) <- paste("y")
data <- data.frame(cbind(y, x))
PPCR(data, eta = 0.0035, m = 3, alpha = 0.05, perturbation_factor = 0.1)
}
\seealso{
\code{\link{lm}}: For linear regression models.

\code{\link{prcomp}}: For principal component analysis.
}
\keyword{multivariate}
\keyword{regression}
