% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORdensity.R
\docType{methods}
\name{findDEgenes}
\alias{findDEgenes}
\alias{findDEgenes,ORdensity-method}
\title{Clustering of the potential differentially expressed (DE) genes}
\usage{
findDEgenes(object, numclusters = NULL)

\S4method{findDEgenes}{ORdensity}(object, numclusters = NULL)
}
\arguments{
\item{object}{An object of \code{\link{ORdensity}} class.}

\item{numclusters}{By default \code{NULL}, it inherits from the \code{object} parameter. 
Optionally, an integer number indicating number of clusters.}
}
\value{
A list composed by \eqn{k} lists where \eqn{k} is the best number of clusters found. 
The clusters are ordered based on their importance according to the mean OR values of the clusters 
(the greater the mean OR value of the cluster the more important are the genes in the cluster).
The first one is the most important, the last one the less important. Each list has elements:
\itemize{
\item \code{numberOfGenes}: Number of genes in the cluster.
\item \code{CharacteristicsCluster}: Matrix with mean values and standard deviation of variables OR, FP and dFP for each cluster.
\item \code{Genes}: Identification of the genes in the cluster.
}
}
\description{
This function clusters the potential differentially expressed (DE) genes among them 
so that the real DE genes can be distinguished from the not DE genes.
}
\examples{
# Read data from 2 experimental conditions
simexpr_reduced <- simexpr[c(1:15,101:235),]
x <- simexpr_reduced[, 3:32]
y <- simexpr_reduced[, 33:62]
EXC.1 <- as.matrix(x)
EXC.2 <- as.matrix(y)
myORdensity <- new("ORdensity", Exp_cond_1 = EXC.1, Exp_cond_2 = EXC.2, B = 20)
out <- findDEgenes(myORdensity)
# For instance, characteristics of cluster1, likely composed of true DE genes 
out[[1]]
# It is also possible to choose the number of clusters
out <- findDEgenes(myORdensity, 5)
}
