% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degree.R
\name{degree}
\alias{degree}
\title{decimal degree coordinate conversion}
\usage{
degree(lat, long, data, todms = !is.character(lat), digits = 1,
  drop = FALSE)
}
\arguments{
\item{lat}{Point latitude(s) (North/South).}

\item{long}{Point longitude(s) (East/West)}

\item{data}{Optional: data.frame with the columns lat and long.}

\item{todms}{Logical specifying direction of conversion.
If FALSE, converts to decimal degree notation, splitting coordinates
at the symbols for degree, minute and second (\\U00B0, ', ").
DEFAULT: !is.character(lat)}

\item{digits}{Number of digits the seconds are \code{\link{round}ed} to. DEFAULT: 1}

\item{drop}{Drop to lowest dimension? DEFAULT: FALSE}
}
\value{
data.frame with x and y as character strings or numerical values,
        depending on conversion direction
}
\description{
Convert latitude-longitude coordinates
between decimal representation and degree-minute-second notation
}
\examples{
# DECIMAL to DMS notation: --------------------------------------------------
degree(52.366360, 13.024181)
degree(c(52.366360, -32.599203), c(13.024181,-55.809601))
degree(52.366360, 13.024181, drop=TRUE) # vector
degree(47.001, -13.325731, digits=5)

# Use table with values instead of single vectors:
d <- read.table(header=TRUE, sep=",", text="
lat, long
 52.366360,  13.024181
-32.599203, -55.809601")
degree(data=d)

# DMS to DECIMAL notation: --------------------------------------------------
# You can use the degree symbol and escaped quotation mark (\\") as well.
degree("52'21'58.9'N", "13'1'27.1'E")
print(degree("52'21'58.9'N", "13'1'27.1'E"), digits=15)

d2 <- read.table(header=TRUE, stringsAsFactors=FALSE, text="
lat long
52'21'58.9'N 13'01'27.1'E
32'35'57.1'S 55'48'34.6'W") # columns cannot be comma-separated!
degree(data=d2)

# Rounding error checks: ----------------------------------------------------
oo <- options(digits=15)
d
degree(data=degree(data=d))
degree(data=degree(data=d, digits=3))
options(oo)
stopifnot(all(degree(data=degree(data=d, digits=3))==d))

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Aug 2016
}
\seealso{
\code{\link{earthDist}}, \code{\link{projectPoints}} for geographical reprojection,
         \code{sp::\link[sp]{char2dms}}
}
\keyword{character}
\keyword{spatial}

