% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{HShannon}
\alias{HShannon}
\title{A function to compute Shannon-Wiener diversity index}
\usage{
HShannon(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Shannon-Wiener diversity index
}
\description{
Shannon-Wiener diversity index is based on entropy
notion and measures the population heterogeneity.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
HShannon(x)
}
\references{
Shannon C. E. (1948) \emph{A mathematical theory
of communication}. Bell System Technical Journal (27)
}
\seealso{
Other multigroup eveness indices:
\code{\link{JPielou}}, \code{\link{ISimpson}},
\code{\link{GiniMulti}}, \code{\link{DMulti}}

Other multigroup indices: \code{\link{PIsol}},
\code{\link{RelDivers}}
}

