% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{ISimpson}
\alias{ISimpson}
\title{A function to compute Simpson's interaction index}
\usage{
ISimpson(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Simpson's interaction index
}
\description{
Simpson's interaction index measures the probability
that individuals randomly selected are not the same group.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
ISimpson(x)
}
\references{
Simpson E. H. (1949) \emph{Measurement of diversity}.
Nature 163:688
}
\seealso{
Other multigroup eveness indices:
\code{\link{HShannon}}, \code{\link{JPielou}}, \code{\link{GiniMulti}},
\code{\link{DMulti}}

Other multigroup indices: \code{\link{PIsol}},
\code{\link{RelDivers}}
}

