% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{LQ}
\alias{LQ}
\title{A function to compute location quotients (LQs)}
\usage{
LQ(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A matrix with LQs
}
\description{
Location quotients compare the relative part of
group in each spatial unit to the relative part of that same
group in the area.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
LQ(x)
}
\references{
Isard W. (1960) \emph{Methods of regional analysis:
an introduction to regional science}. The MIT Press, Cambridge
}
\seealso{
Other local indices:  local entropy index \code{\link{HLoc}}
}

