% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Morill}
\alias{Morill}
\title{A function to compute Morill's segregation index}
\usage{
Morill(x, c = NULL, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{c}{- a binary contiguity (adjacency) symetric matrix where each
element \emph{Cij} equals 1 if \emph{i}-th and \emph{j}-th spatial units
are adjacent, 0 otherwise.}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A vector with Morill segregation index
}
\description{
Morill's segregation index develops \code{\link{Duncan}}'s
index by taking into account the interactions between spatial units
(contiguity). The function can be used in two ways: by providing a
contiguity matrix or a geographic source (spatial object or shape file)
wich will be used to compute the contiguity matrix within the function
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
contiguity <- contig(GreHSize)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'

Morill(x, c = contiguity)

Morill(x, spatobj = GreHSize)

Morill(x, folder = foldername, shape = shapename)
}
\references{
Morill B. (1991) \emph{On the measure of geographic
segregation}. Geography research forum, 11, pp. 25-36.
}
\seealso{
Other evenness intragroup  indices:
\code{\link{Duncan}}, \code{\link{Wong}}, \code{\link{Gini}},
\code{\link{Gorard}}

Intergroup dissimilarity index: \code{\link{DI}}
}

