% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{contig}
\alias{contig}
\title{A function to compute the contiguity matrix}
\usage{
contig(spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{spatobj}{- a Spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A first order contiguity (adjacency) matrix, where each
element [\emph{i,j}] equals 1 if \emph{i}-th  and \emph{j}-th
spatial units are adjacent, 0 otherwise (queen criteria)
}
\description{
The function is based on \pkg{rgdal} and
\pkg{spdep} packages and it can be used by providing a shape
file or a R spatial object (SpatialPolygonsDataFrame).
}
\examples{
contig(GreHSize)

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'
contig(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices
computation: \code{\link{area}}, \code{\link{perimeter}},
\code{\link{distance}}, \code{\link{distcenter}},
\code{\link{boundaries}}, \code{\link{xgeo}}
}

