% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{xseg}
\alias{xseg}
\title{A function to compute all segregation indices developped in OasisR}
\usage{
xseg(x, center = 1, fdist = 'l', spatobj = NULL, folder = NULL, shape = NULL )
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{center}{- a value giving the number of the spatial unit
that represents the area's center}

\item{fdist}{- the method used for distance calculations:
'l' for linear (by default) and 'e' for exponential function.}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A list with segregation indices
}
\description{
A general function that computes all segregation indexes available in OasisR package
}
\examples{
x <- slot(AnnHAge, 'data')[ ,3:5]
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'AnnHAge'

xseg(x, center = 1, spatobj = AnnHAge)

xseg(x, center = 1, folder = foldername, shape = shapename)
}
\references{
Tivadar M., Schaeffer Y, Torre A. and Bray F. (2014) \emph{OASIS -
un Outil d'Analyse de la Segregation et des Inegalites Spatiales}.
Cybergeo : European Journal of Geography, GeOpenMod, document 699
}
\seealso{
\code{\link{xgeo}} function which computes all geografical information necessary for segregation indices

\code{\link{MCTest}} function which computes Monte Carlos simulations to test segregation indexes
}

