% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{MCPlot}
\alias{MCPlot}
\title{A function to plot the results of Monte Carlo simulations}
\usage{
MCPlot(MCTest = NULL, var = 1, dens = NULL, ind = NULL, pval = NULL, 
indexname = 'Index', coldist = 'red', colind = 'blue', legend = T, 
legendpos = 'top', cex.legend = 1, bty = 'o')
}
\arguments{
\item{MCTest}{- a MCTest object prodused with \code{\link{MCTest}} function
to be tested (only one-group or multigroup indeces)}

\item{var}{- the number of the group to be plot (if several groups are simulated)}

\item{dens}{- a vector with the simulatated distribution of the index}

\item{ind}{- index value}

\item{pval}{- pseudo p-value}

\item{indexname}{- a string with the name of the index}

\item{coldist}{- color used to plot the simulated distribution}

\item{colind}{- color used to plot the index}

\item{legend}{- logical parameter, to control the legend's plots}

\item{legendpos}{- a character string giving the legend's position: 
"bottomright", "bottom", "bottomleft", "left", "topleft", "top", 
"topright", "right" and "center".}

\item{cex.legend}{- a numerical value giving the amount by which 
plotting text and symbols in legend should be magnified relative to the default.}

\item{bty}{- a character string which determines the type of box 
of the legend. If bty is one of "o" (the default), "l", "7", "c", 
"u", or "]" the resulting box resembles the corresponding upper 
case letter. A value of "n" suppresses the box.}
}
\value{
A plot with Monte Carlo results
}
\description{
Plot of Monte Carlo simulations results. The function can
be used in two ways: buy providing a MCTest object, using \code{\link{MCTest}} 
or a simulated distribution vector, a value and a name of the index
}
\examples{
x <- segdata@data[ ,1:2]
test <- MCTest (x, fun='ISMorrill', simtype = 'perm', spatobj = segdata)

MCPlot(test, cex.legend = 0.8)

MCPlot(dens = test$Distribution[1,], ind = test$Summary$ISMorrill[1], 
pval = test$Summary$P.Value[1], indexname = test$Index, cex.legend = 0.8)

}
\references{
Tivadar M., Schaeffer Y, Torre A. and Bray F. (2014) 
\emph{OASIS - un Outil d'Analyse de la Segregation et des Inegalites 
Spatiales}.  Cybergeo : European Journal of Geography, GeOpenMod, 
document 699
}
\seealso{
\code{\link{MCTest}}
}

