% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helpers.R
\name{getExampleConnectionDetails}
\alias{getExampleConnectionDetails}
\title{create a connection detail for an example OHDSI results database}
\usage{
getExampleConnectionDetails(exdir = tempdir())
}
\arguments{
\item{exdir}{a directory to unzip the example result data into.  Default is tempdir().}
}
\value{
An object of class `ConnectionDetails` with the details to connect to the example OHDSI result database
}
\description{
This returns an object of class `ConnectionDetails` that lets you connect via `DatabaseConnector::connect()` to the example result database.
}
\details{
Finds the location of the example result database in the package and calls `DatabaseConnector::createConnectionDetails` to create a `ConnectionDetails` object for connecting to the database.
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

}
\seealso{
Other helper: 
\code{\link{addTarColumn}()},
\code{\link{formatBinaryCovariateName}()},
\code{\link{kableDark}()},
\code{\link{printReactable}()},
\code{\link{removeSpaces}()}
}
\concept{helper}
