/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.comparator;

import org.andwellness.xml.datagenerator.comparator.DataPointComparator;
import org.andwellness.xml.datagenerator.model.DataPoint;

public abstract class AbstractDataPointComparator
implements DataPointComparator {
    @Override
    public boolean compare(DataPoint dataPoint, String value2, String condition2) {
        if (dataPoint.isNotDisplayed()) {
            return false;
        }
        if (dataPoint.isSkipped()) {
            return "==".equals(condition2) && "SKIPPED".equals(value2);
        }
        if ("==".equals(condition2)) {
            return this.equals(dataPoint, value2);
        }
        if ("!=".equals(condition2)) {
            return this.notEquals(dataPoint, value2);
        }
        if ("<".equals(condition2)) {
            return this.lessThan(dataPoint, value2);
        }
        if (">".equals(condition2)) {
            return this.greaterThan(dataPoint, value2);
        }
        if ("<=".equals(condition2)) {
            return this.lessThanOrEquals(dataPoint, value2);
        }
        if (">=".equals(condition2)) {
            return this.greaterThanOrEquals(dataPoint, value2);
        }
        throw new IllegalArgumentException("The condition is not valid.");
    }

    abstract boolean equals(DataPoint var1, String var2);

    abstract boolean notEquals(DataPoint var1, String var2);

    abstract boolean greaterThan(DataPoint var1, String var2);

    abstract boolean greaterThanOrEquals(DataPoint var1, String var2);

    abstract boolean lessThan(DataPoint var1, String var2);

    abstract boolean lessThanOrEquals(DataPoint var1, String var2);
}

