/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.utility;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;

public class ValueCreator {
    private static Random _random = new Random();
    private static String[] _tzs = new String[]{"America/Los_Angeles"};
    private static SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat isoDateFormatWithT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static String[] _providers = new String[]{"null", "GPS", "network"};
    private static String[] _customChoices = new String[]{"foo", "bar", "baz", "biz", "beer"};
    private static String[] _mobilityModes = new String[]{"still", "walk", "run", "bike", "drive", "error"};
    private static String[] _locationStatuses = new String[]{"valid", "inaccurate", "stale"};
    private static char[] _hexChars = "0123456789ABCDEF".toCharArray();

    private ValueCreator() {
    }

    public static double latitude() {
        return (double)(_random.nextInt() % 90) + _random.nextDouble();
    }

    public static double longitude() {
        return (double)(_random.nextInt() % 180) + _random.nextDouble();
    }

    public static double latitude(double max, double min) {
        return _random.nextDouble() * (max - min) + min;
    }

    public static double longitude(double max, double min) {
        return _random.nextDouble() * (max - min) + min;
    }

    public static long epoch() {
        return System.currentTimeMillis();
    }

    public static long epoch(int num_days_ago) {
        return System.currentTimeMillis() - 86400000L * (long)num_days_ago;
    }

    public static long epoch(Date date) {
        return date.getTime();
    }

    public static String tz() {
        return _tzs[0];
    }

    public static String date() {
        return isoDateFormat.format(new Date());
    }

    public static String dateWithT() {
        return isoDateFormatWithT.format(new Date());
    }

    public static String date(Date date) {
        return isoDateFormat.format(date);
    }

    public static String date(int num_days_ago) {
        return isoDateFormat.format(new Date(ValueCreator.epoch(num_days_ago)));
    }

    public static String hours_before_date(Date date, int hoursBeforeDate) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(11, -1 * hoursBeforeDate);
        return ValueCreator.date(calendar.getTime());
    }

    public static String hours_before_now(Map<String, String> properties) {
        int minHours = Integer.valueOf(properties.get("min"));
        int maxHours = Integer.valueOf(properties.get("max"));
        int range = maxHours - minHours;
        int hours = _random.nextInt() % range + minHours;
        Date newDate = new Date(ValueCreator.epoch() - (long)(hours * 1000 * 60 * 60));
        return isoDateFormat.format(newDate);
    }

    public static String single_choice(Map<String, String> properties) {
        Set<String> keySet = properties.keySet();
        int keyChoice = _random.nextInt(keySet.size());
        String chosenKey = (String)keySet.toArray()[keyChoice];
        return chosenKey;
    }

    public static List<String> multiChoice(Map<String, String> properties) {
        ArrayList<String> chosenChoices = new ArrayList<String>();
        Set<String> keySet = properties.keySet();
        double oddsOfChoosing = 0.5;
        for (String keyValue : keySet) {
            if (!(_random.nextDouble() < oddsOfChoosing)) continue;
            chosenChoices.add(keyValue);
        }
        return chosenChoices;
    }

    public static double randomPositiveDouble() {
        return Math.abs(_random.nextDouble());
    }

    public static double randomDouble() {
        return _random.nextDouble();
    }

    public static float randomPositiveFloat() {
        return Math.abs(_random.nextFloat());
    }

    public static boolean randomBoolean() {
        return _random.nextBoolean();
    }

    public static String randomTime() {
        String hours = String.valueOf(Math.abs(_random.nextInt() % 24));
        int m = Math.abs(_random.nextInt() % 60);
        String minutes = m < 10 ? "0" + m : String.valueOf(m);
        return hours + ":" + minutes;
    }

    public static String randomTime(int average_hour, int hour_range) {
        int h = Math.abs((average_hour + _random.nextInt(hour_range + 1) - hour_range / 2) % 24);
        String hours = String.valueOf(h);
        int m = Math.abs(_random.nextInt() % 60);
        String minutes = m < 10 ? "0" + m : String.valueOf(m);
        return hours + ":" + minutes;
    }

    public static int randomPositiveIntModulus(int modulus) {
        return Math.abs(_random.nextInt() % modulus);
    }

    public static long randomPositiveLongModulus(long modulus) {
        return Math.abs(_random.nextLong() % modulus);
    }

    public static String randomProvider() {
        return _providers[Math.abs(_random.nextInt() % 3)];
    }

    public static String randomCustomChoice() {
        return _customChoices[_random.nextInt(_customChoices.length)];
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String mode() {
        return _mobilityModes[_random.nextInt(_mobilityModes.length)];
    }

    public static String randomMacAddress() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            builder.append(_hexChars[ValueCreator.randomPositiveIntModulus(_hexChars.length)]).append(_hexChars[ValueCreator.randomPositiveIntModulus(_hexChars.length)]);
            if (i >= 5) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    public static String randomLocationStatus() {
        return _locationStatuses[ValueCreator.randomPositiveIntModulus(3)];
    }
}

