/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Node;
import nu.xom.Nodes;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.ChoiceCustom;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;

public class MultiChoiceCustomDataPointCreator
extends DataPointCreator {
    private Logger _logger = Logger.getLogger(MultiChoiceCustomDataPointCreator.class);

    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        ArrayList<String> possibleChoices = new ArrayList<String>();
        ChoiceCustom customChoiceModel = new ChoiceCustom();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.multi_choice_custom);
        createdDataPoint.setDisplayType(displayType);
        Nodes propertyNodes = currentNode.query("properties");
        if (propertyNodes.size() == 1) {
            Node propertyNode = propertyNodes.get(0);
            Map<String, String> nodeProperties = this.extractProperties(propertyNode);
            for (String propertyValue : nodeProperties.values()) {
                possibleChoices.add(propertyValue);
            }
        }
        for (int i = 0; i < 2; ++i) {
            possibleChoices.add(ValueCreator.randomCustomChoice());
        }
        Iterator possibleChoicesIterator = possibleChoices.iterator();
        int possibleChoicesIndex = 0;
        while (possibleChoicesIterator.hasNext()) {
            String possibleChoice = (String)possibleChoicesIterator.next();
            if (ValueCreator.randomBoolean()) {
                customChoiceModel.addSelectedChoice(possibleChoice);
            }
            ++possibleChoicesIndex;
        }
        createdDataPoint.setValue(customChoiceModel);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating a multi choice custom data point with id " + nodeId);
        }
        return createdDataPoint;
    }
}

