/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.expr;

import java.util.ArrayList;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.expr.DefaultExpr;
import nu.xom.jaxen.expr.Expr;
import nu.xom.jaxen.expr.FilterExpr;
import nu.xom.jaxen.expr.Predicate;
import nu.xom.jaxen.expr.PredicateSet;
import nu.xom.jaxen.expr.Predicated;

public class DefaultFilterExpr
extends DefaultExpr
implements FilterExpr,
Predicated {
    private static final long serialVersionUID = -549640659288005735L;
    private Expr expr;
    private PredicateSet predicates;

    public DefaultFilterExpr(PredicateSet predicateSet) {
        this.predicates = predicateSet;
    }

    public DefaultFilterExpr(Expr expr2, PredicateSet predicateSet) {
        this.expr = expr2;
        this.predicates = predicateSet;
    }

    public void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    public List getPredicates() {
        return this.predicates.getPredicates();
    }

    public PredicateSet getPredicateSet() {
        return this.predicates;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public String toString() {
        return "[(DefaultFilterExpr): expr: " + this.expr + " predicates: " + this.predicates + " ]";
    }

    public String getText() {
        String string = "";
        if (this.expr != null) {
            string = this.expr.getText();
        }
        string = string + this.predicates.getText();
        return string;
    }

    public Expr simplify() {
        this.predicates.simplify();
        if (this.expr != null) {
            this.expr = this.expr.simplify();
        }
        if (this.predicates.getPredicates().size() == 0) {
            return this.getExpr();
        }
        return this;
    }

    public boolean asBoolean(Context context) throws JaxenException {
        Object object;
        ArrayList arrayList = null;
        if (this.expr != null) {
            arrayList = this.expr.evaluate(context);
        } else {
            object = context.getNodeSet();
            ArrayList arrayList2 = new ArrayList(object.size());
            arrayList2.addAll(object);
            arrayList = arrayList2;
        }
        if (arrayList instanceof Boolean) {
            object = (Boolean)((Object)arrayList);
            return (Boolean)object;
        }
        if (arrayList instanceof List) {
            return this.getPredicateSet().evaluateAsBoolean(arrayList, context.getContextSupport());
        }
        return false;
    }

    public Object evaluate(Context context) throws JaxenException {
        Object object = this.getExpr().evaluate(context);
        if (object instanceof List) {
            List list = this.getPredicateSet().evaluatePredicates((List)object, context.getContextSupport());
            object = list;
        }
        return object;
    }
}

