% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_lod.R
\name{olink_lod}
\alias{olink_lod}
\title{Calculate LOD using Negative Controls or Fixed LOD}
\usage{
olink_lod(data, lod_file_path = NULL, lod_method = "NCLOD")
}
\arguments{
\item{data}{npx data file}

\item{lod_file_path}{location of lod file from Olink. Only needed if
lod_method = "FixedLOD" or "Both". Default \code{NULL}.}

\item{lod_method}{method for calculating LOD using either "FixedLOD" or
negative controls ("NCLOD"), or both ("Both"). Default \code{NCLOD}.}
}
\value{
A dataframe with 2 additional columns, LOD and PCNormalizedLOD if \code{lod_method} is FixedLOD or NCLOD. When \code{Normalization = "Plate Control"}, LOD and PCNormalizedLOD are identical.

If \code{lod_method} is "Both", 4 additional columns will be added:
\itemize{
\item NCLOD - LOD calculated from negative controls and normalized based on normalization column
\item NCPCNormalizedLOD - PC Normalized LOD calculated from negative controls
\item FixedLOD - LOD calculated from fixed LOD file and normalized based on normalization column
\item FixedPCNormalizedLOD - PC Normalized LOD calculated from fixed LOD file
}
}
\description{
Calculate LOD using Negative Controls or Fixed LOD
}
\examples{
\dontrun{
   \donttest{
  try({ # This will fail if the files do not exist.

  # Import NPX data
    npx_data <- read_NPX("path/to/npx_file")

  # Estimate LOD from negative controls
    npx_data_lod_NC <- olink_lod(data = npx_data,  lod_method = "NCLOD")

  # Estimate LOD from fixed LOD
  ## Locate the fixed LOD file
    lod_file_path <- "path/to/lod_file"

    npx_data_lod_Fixed <- olink_lod(data = npx_data,
                                    lod_file_path = lod_file_path,
                                    lod_method = "FixedLOD")
     })
  }
}

}
