% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseClinicalRecords.R
\name{summariseClinicalRecords}
\alias{summariseClinicalRecords}
\title{Summarise an omop table from a cdm object. You will obtain
information related to the number of records, number of subjects, whether the
records are in observation, number of present domains and number of present
concepts.}
\usage{
summariseClinicalRecords(
  cdm,
  omopTableName,
  recordsPerPerson = c("mean", "sd", "median", "q25", "q75", "min", "max"),
  inObservation = TRUE,
  standardConcept = TRUE,
  sourceVocabulary = TRUE,
  domainId = TRUE,
  typeConcept = TRUE,
  sex = FALSE,
  ageGroup = NULL,
  sample = NULL,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm_reference object.}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object.}

\item{recordsPerPerson}{Generates summary statistics for the number of
records per person. Set to NULL if no summary statistics are required.}

\item{inObservation}{Boolean variable. Whether to include the percentage of
records in observation.}

\item{standardConcept}{Boolean variable. Whether to summarise standard
concept information.}

\item{sourceVocabulary}{Boolean variable.  Whether to summarise source
vocabulary information.}

\item{domainId}{Boolean variable. Whether to summarise domain id of standard
concept id information.}

\item{typeConcept}{Boolean variable. Whether to summarise type concept id
field information.}

\item{sex}{Boolean variable. Whether to stratify by sex (TRUE) or not
(FALSE).}

\item{ageGroup}{A list of age groups to stratify results by.}

\item{sample}{An integer to sample the tables to only that number of records.
If NULL no sample is done.}

\item{dateRange}{A list containing the minimum and the maximum dates
defining the time range within which the analysis is performed.}
}
\value{
A summarised_result object.
}
\description{
Summarise an omop table from a cdm object. You will obtain
information related to the number of records, number of subjects, whether the
records are in observation, number of present domains and number of present
concepts.
}
\examples{
\donttest{
cdm <- mockOmopSketch()

summarisedResult <- summariseClinicalRecords(
  cdm = cdm,
  omopTableName = "condition_occurrence",
  recordsPerPerson = c("mean", "sd"),
  inObservation = TRUE,
  standardConcept = TRUE,
  sourceVocabulary = TRUE,
  domainId = TRUE,
  typeConcept = TRUE
)

summarisedResult

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
