% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blrm_formula_linear.R
\name{blrm_formula_linear}
\alias{blrm_formula_linear}
\title{Build a BLRM formula with linear interaction term in logit-space}
\usage{
blrm_formula_linear(ref_doses, max_interaction_level = 2)
}
\arguments{
\item{ref_doses}{Numeric vector of reference doses with names corresponding to drug names}

\item{max_interaction_level}{Highest interaction order to consider [1 - Inf]. Default: 2}
}
\value{
The function returns an object of class \code{blrm_formula}.
}
\description{
\code{blrm_formula_linear} is a convenience function for generating
a formula for \code{blrm_trial} and \code{blrm_exnex}.
}
\examples{

ref_doses <- c(drug_A=10, drug_B=20)

# can be used with blrm_trial
blrm_formula_linear(ref_doses)

}
