% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_model.R
\name{example_model}
\alias{example_model}
\title{Runs example models}
\usage{
example_model(topic, envir = parent.frame(), silent = FALSE)
}
\arguments{
\item{topic}{example to run}

\item{envir}{environment which the example is loaded into. Defaults
to the caller environment.}

\item{silent}{logical controlling if execution is run silently
(defaults to \code{FALSE})}
}
\value{
When topic is not specified a list of all possible topics
    is return. Whenever a valid topic is specified, the function
    inserts the example into the environment given and returns
    (invisibly) the updated environment.
}
\description{
Runs example models
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)


## get a list of available examples
example_model()

## run 3 component example
example_model("combo3")

## Recover user set sampling defaults
options(.user_mc_options)

}
