% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_interval.R
\name{posterior_interval.blrmfit}
\alias{posterior_interval.blrmfit}
\alias{posterior_interval}
\title{Posterior intervals}
\usage{
\method{posterior_interval}{blrmfit}(object, prob = 0.95, ...)
}
\arguments{
\item{object}{fitted model object}

\item{prob}{central probability mass to report, i.e. the quantiles
0.5-prob/2 and 0.5+prob/2 are displayed. Multiple central
widths can be specified.}

\item{...}{not used in this function}
}
\value{
Matrix of two columns for the central probability interval
    \code{prob} for all parameters of the model.
}
\description{
Posterior intervals of all model parameters.
}
\details{
Reports the quantiles of posterior parameters which correspond to
the central probability mass specified. The output includes the
posterior of the hyper-parameters and the posterior of each group
estimate.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

example_model("single_agent")

posterior_interval(blrmfit)

## Recover user set sampling defaults
options(.user_mc_options)

}
