# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

diate_erode <- function(image, Filter, method = 1L, threads = 1L) {
    .Call('OpenImageR_diate_erode', PACKAGE = 'OpenImageR', image, Filter, method, threads)
}

diate_erode_cube <- function(image, Filter, method = 1L, threads = 1L) {
    .Call('OpenImageR_diate_erode_cube', PACKAGE = 'OpenImageR', image, Filter, method, threads)
}

#' convert an RGB image to Gray
#' 
#' @param RGB_image a 3-dimensional array
#' @return a matrix
#' @author Lampros Mouselimis
#' @details
#' This function converts an RGB image to gray
#' @export
#' @examples
#' 
#' path = system.file("tmp_images", "1.png", package = "OpenImageR")
#' 
#' image = readImage(path)
#' 
#' gray = rgb_2gray(image)
rgb_2gray <- function(RGB_image) {
    .Call('OpenImageR_rgb_2gray', PACKAGE = 'OpenImageR', RGB_image)
}

hog_cpp <- function(image, n_divs = 3L, n_bins = 6L) {
    .Call('OpenImageR_hog_cpp', PACKAGE = 'OpenImageR', image, n_divs, n_bins)
}

HOG_matrix <- function(x, height, width, n_divs = 3L, n_bins = 6L, threads = 1L) {
    .Call('OpenImageR_HOG_matrix', PACKAGE = 'OpenImageR', x, height, width, n_divs, n_bins, threads)
}

HOG_array <- function(x, n_divs = 3L, n_bins = 6L, threads = 1L) {
    .Call('OpenImageR_HOG_array', PACKAGE = 'OpenImageR', x, n_divs, n_bins, threads)
}

round_rcpp <- function(f, decimal_places = 5L) {
    .Call('OpenImageR_round_rcpp', PACKAGE = 'OpenImageR', f, decimal_places)
}

binary_to_hex <- function(x) {
    .Call('OpenImageR_binary_to_hex', PACKAGE = 'OpenImageR', x)
}

levenshtein_dist <- function(s, t) {
    .Call('OpenImageR_levenshtein_dist', PACKAGE = 'OpenImageR', s, t)
}

func_dct <- function(x) {
    .Call('OpenImageR_func_dct', PACKAGE = 'OpenImageR', x)
}

dct_2d <- function(x) {
    .Call('OpenImageR_dct_2d', PACKAGE = 'OpenImageR', x)
}

phash_binary <- function(gray_image, hash_size = 8L, highfreq_factor = 4L, resize_method = "nearest") {
    .Call('OpenImageR_phash_binary', PACKAGE = 'OpenImageR', gray_image, hash_size, highfreq_factor, resize_method)
}

phash_string <- function(gray_image, hash_size = 8L, highfreq_factor = 4L, resize_method = "nearest") {
    .Call('OpenImageR_phash_string', PACKAGE = 'OpenImageR', gray_image, hash_size, highfreq_factor, resize_method)
}

average_hash_binary <- function(gray_image, hash_size = 8L, resize_method = "nearest") {
    .Call('OpenImageR_average_hash_binary', PACKAGE = 'OpenImageR', gray_image, hash_size, resize_method)
}

average_hash_string <- function(gray_image, hash_size = 8L, resize_method = "nearest") {
    .Call('OpenImageR_average_hash_string', PACKAGE = 'OpenImageR', gray_image, hash_size, resize_method)
}

dhash_binary <- function(gray_image, hash_size = 8L, resize_method = "nearest") {
    .Call('OpenImageR_dhash_binary', PACKAGE = 'OpenImageR', gray_image, hash_size, resize_method)
}

dhash_string <- function(gray_image, hash_size = 8L, resize_method = "nearest") {
    .Call('OpenImageR_dhash_string', PACKAGE = 'OpenImageR', gray_image, hash_size, resize_method)
}

hash_image <- function(x, new_width, new_height, hash_size = 8L, highfreq_factor = 4L, method = 1L, threads = 1L, resize_method = "nearest") {
    .Call('OpenImageR_hash_image', PACKAGE = 'OpenImageR', x, new_width, new_height, hash_size, highfreq_factor, method, threads, resize_method)
}

hash_image_cube <- function(x, hash_size = 8L, highfreq_factor = 4L, method = 1L, threads = 1L, resize_method = "nearest") {
    .Call('OpenImageR_hash_image_cube', PACKAGE = 'OpenImageR', x, hash_size, highfreq_factor, method, threads, resize_method)
}

list_2array_convert <- function(x) {
    .Call('OpenImageR_list_2array_convert', PACKAGE = 'OpenImageR', x)
}

hash_image_hex <- function(x, new_width, new_height, hash_size = 8L, highfreq_factor = 4L, method = 1L, threads = 1L, resize_method = "nearest") {
    .Call('OpenImageR_hash_image_hex', PACKAGE = 'OpenImageR', x, new_width, new_height, hash_size, highfreq_factor, method, threads, resize_method)
}

hash_image_cube_hex <- function(x, hash_size = 8L, highfreq_factor = 4L, method = 1L, threads = 1L, resize_method = "nearest") {
    .Call('OpenImageR_hash_image_cube_hex', PACKAGE = 'OpenImageR', x, hash_size, highfreq_factor, method, threads, resize_method)
}

mod <- function(a, b) {
    .Call('OpenImageR_mod', PACKAGE = 'OpenImageR', a, b)
}

indices <- function(rows, cols) {
    .Call('OpenImageR_indices', PACKAGE = 'OpenImageR', rows, cols)
}

vec2mat <- function(V, mat_rows, mat_cols) {
    .Call('OpenImageR_vec2mat', PACKAGE = 'OpenImageR', V, mat_rows, mat_cols)
}

seq_rcpp <- function(x) {
    .Call('OpenImageR_seq_rcpp', PACKAGE = 'OpenImageR', x)
}

resize_nearest_rcpp <- function(image, width, height) {
    .Call('OpenImageR_resize_nearest_rcpp', PACKAGE = 'OpenImageR', image, width, height)
}

resize_nearest_array <- function(image, width, height) {
    .Call('OpenImageR_resize_nearest_array', PACKAGE = 'OpenImageR', image, width, height)
}

indices_bilinear <- function(rows, cols) {
    .Call('OpenImageR_indices_bilinear', PACKAGE = 'OpenImageR', rows, cols)
}

meshgrid_x <- function(rows, cols) {
    .Call('OpenImageR_meshgrid_x', PACKAGE = 'OpenImageR', rows, cols)
}

meshgrid_y <- function(rows, cols) {
    .Call('OpenImageR_meshgrid_y', PACKAGE = 'OpenImageR', rows, cols)
}

replaceVal <- function(x, thresh, value, mode = 1L) {
    .Call('OpenImageR_replaceVal', PACKAGE = 'OpenImageR', x, thresh, value, mode)
}

vec2mat_colwise <- function(VEC, mat_rows, mat_cols) {
    .Call('OpenImageR_vec2mat_colwise', PACKAGE = 'OpenImageR', VEC, mat_rows, mat_cols)
}

Vectz <- function(x) {
    .Call('OpenImageR_Vectz', PACKAGE = 'OpenImageR', x)
}

resize_bilinear_rcpp <- function(image, width, height) {
    .Call('OpenImageR_resize_bilinear_rcpp', PACKAGE = 'OpenImageR', image, width, height)
}

bilinear_array <- function(image, width, height) {
    .Call('OpenImageR_bilinear_array', PACKAGE = 'OpenImageR', image, width, height)
}

Array_range <- function(x, mode = 1L) {
    .Call('OpenImageR_Array_range', PACKAGE = 'OpenImageR', x, mode)
}

Normalize_array <- function(x) {
    .Call('OpenImageR_Normalize_array', PACKAGE = 'OpenImageR', x)
}

Normalize_matrix <- function(x) {
    .Call('OpenImageR_Normalize_matrix', PACKAGE = 'OpenImageR', x)
}

rotate_rcpp <- function(image, angle) {
    .Call('OpenImageR_rotate_rcpp', PACKAGE = 'OpenImageR', image, angle)
}

seq_rcpp_range <- function(start, end) {
    .Call('OpenImageR_seq_rcpp_range', PACKAGE = 'OpenImageR', start, end)
}

rotate_nearest_bilinear <- function(image, angle, method, mode, threads) {
    .Call('OpenImageR_rotate_nearest_bilinear', PACKAGE = 'OpenImageR', image, angle, method, mode, threads)
}

rotate_nearest_bilinear_array_same <- function(src, angle, method, threads) {
    .Call('OpenImageR_rotate_nearest_bilinear_array_same', PACKAGE = 'OpenImageR', src, angle, method, threads)
}

rotate_nearest_bilinear_array_full <- function(src, angle, method, threads) {
    .Call('OpenImageR_rotate_nearest_bilinear_array_full', PACKAGE = 'OpenImageR', src, angle, method, threads)
}

conv2d <- function(image, kernel, mode) {
    .Call('OpenImageR_conv2d', PACKAGE = 'OpenImageR', image, kernel, mode)
}

conv3d <- function(image, kernel, mode) {
    .Call('OpenImageR_conv3d', PACKAGE = 'OpenImageR', image, kernel, mode)
}

svd_arma_econ <- function(m) {
    .Call('OpenImageR_svd_arma_econ', PACKAGE = 'OpenImageR', m)
}

removeMean <- function(data) {
    .Call('OpenImageR_removeMean', PACKAGE = 'OpenImageR', data)
}

zca_whitening <- function(data, k, epsilon) {
    .Call('OpenImageR_zca_whitening', PACKAGE = 'OpenImageR', data, k, epsilon)
}

zca_whiten_cube <- function(src, k, epsilon) {
    .Call('OpenImageR_zca_whiten_cube', PACKAGE = 'OpenImageR', src, k, epsilon)
}

im_flip <- function(x, mode = 1L) {
    .Call('OpenImageR_im_flip', PACKAGE = 'OpenImageR', x, mode)
}

im_flip_cube <- function(src, mode = 1L) {
    .Call('OpenImageR_im_flip_cube', PACKAGE = 'OpenImageR', src, mode)
}

translation_mat <- function(image, shift_rows = 0L, shift_cols = 0L, FILL_VALUE = 0.0) {
    .Call('OpenImageR_translation_mat', PACKAGE = 'OpenImageR', image, shift_rows, shift_cols, FILL_VALUE)
}

augment_transf <- function(image, flip_mode, crop_height, crop_width, resiz_width = 0.0, resiz_height = 0.0, resiz_method = "nearest", shift_rows = 0.0, shift_cols = 0.0, rotate_angle = 0.0, rotate_method = "nearest", zca_comps = 0L, zca_epsilon = 0.0, image_thresh = 0.0, pad_shift_value = 0.0) {
    .Call('OpenImageR_augment_transf', PACKAGE = 'OpenImageR', image, flip_mode, crop_height, crop_width, resiz_width, resiz_height, resiz_method, shift_rows, shift_cols, rotate_angle, rotate_method, zca_comps, zca_epsilon, image_thresh, pad_shift_value)
}

augment_transf_array <- function(image, flip_mode, crop_height, crop_width, pad_shift_value, resiz_width = 0.0, resiz_height = 0.0, resiz_method = "nearest", shift_rows = 0.0, shift_cols = 0.0, rotate_angle = 0.0, rotate_method = "nearest", zca_comps = 0L, zca_epsilon = 0.0, image_thresh = 0.0, threads = 1L) {
    .Call('OpenImageR_augment_transf_array', PACKAGE = 'OpenImageR', image, flip_mode, crop_height, crop_width, pad_shift_value, resiz_width, resiz_height, resiz_method, shift_rows, shift_cols, rotate_angle, rotate_method, zca_comps, zca_epsilon, image_thresh, threads)
}

augment_array_list <- function(x, flip_mode, crop_height, crop_width, pad_shift_value, resiz_width = 0.0, resiz_height = 0.0, resiz_method = "nearest", shift_rows = 0.0, shift_cols = 0.0, rotate_angle = 0.0, rotate_method = "nearest", zca_comps = 0L, zca_epsilon = 0.0, image_thresh = 0.0) {
    .Call('OpenImageR_augment_array_list', PACKAGE = 'OpenImageR', x, flip_mode, crop_height, crop_width, pad_shift_value, resiz_width, resiz_height, resiz_method, shift_rows, shift_cols, rotate_angle, rotate_method, zca_comps, zca_epsilon, image_thresh)
}

MinMaxArray <- function(x) {
    .Call('OpenImageR_MinMaxArray', PACKAGE = 'OpenImageR', x)
}

MinMaxMatrix <- function(x) {
    .Call('OpenImageR_MinMaxMatrix', PACKAGE = 'OpenImageR', x)
}

